/*****************************************************************************
| FILE:         inc_fi_base.h
| PROJECT:      G3g
| SW-COMPONENT: AmControllerPlugin
|------------------------------------------------------------------------------
| DESCRIPTION:  FI Messages over INC
|
|------------------------------------------------------------------------------
| COPYRIGHT:    (c) 2013 Robert Bosch GmbH
| HISTORY:
| Date      | Modification               | Author
| 03.06.13  | Initial revision           | Ranjit Katuri
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

#ifndef INC_FI_BASE_H_INCLUDE_IF
#define INC_FI_BASE_H_INCLUDE_IF

#define HOLLOW_MAN    __attribute__((visibility("hidden")))

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#include <queue>
#include <vector>
#include <pthread.h>
#include <string>
#include <fstream>
#include "ep_mainloop.h"
#include "dgram_service.h"
#include "inc.h"
#include "inc_ports.h"
#include <dlt/dlt.h>

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

/******************************************
*  MACROS
******************************************/
//Check if we really need this size?? As of now using a temporary size of 512 bytes
#define INC_CCA_MSG_MAX_LENGTH   DGRAM_MAX

#ifndef AUDIO_ROUTER_PORT
  #define INC_PORT_CCA_ADAPTER  (0xC717)
#else
#define INC_PORT_CCA_ADAPTER AUDIO_ROUTER_PORT
#endif

#define INC_CCA_ADAPTER_HOST_NAME  "scc-local"  //Host in which INC CCA Adapter is located //ToDo > Replace with actual host name
#define INC_APPLICATION_HOST_NAME  "scc-local"  //Host in which local application is located //ToDo > Replace with actual host name

/** CCA Framework related **/
#ifndef CCA_C_U16_APP_CCA_INC_ADAPTER
  #define APP_ID_INC_CCA_ADAPTER    (0x00A6)
#else
  #define  APP_ID_INC_CCA_ADAPTER   CCA_C_U16_APP_CCA_INC_ADAPTER
#endif

#define SRV_ID_INC_CCA_ADAPTER    (0x5678)
#define INC_CCA_ADAPTER_MAJOR_VERSION (0x01)q
/******************************************
*  CLASS DECLARATION
******************************************/

#if 0
class in_fi_srvreg_sync;
#endif

class amt_tclBaseMessage;

//Tell lint that the below functions will take the custody of pointers sent to them
//lint -sem( std::queue::push, custodial(1) )

class inc_fi_base
{
private:
  /** List of sockets to connect to, as of now only one, but in case if extension is needed, then is useful **/
  int            m_sockfdccagw;
  /** Dgram for the socket **/
  sk_dgram*        m_dgram;
protected:
  /** Main loop **/
  ep_mainloop             m_mainloop;
  /**
  * Default constructors protected
  */
  inc_fi_base();
  inc_fi_base(const inc_fi_base&);

private:
  /** listener thread **/
  pthread_t        m_dptask;
  /** Event fd for listener thread **/
  int            m_evfdccamsg;
  /** List to hold CCA Messages **/
  std::queue<amt_tclBaseMessage*>  m_ccamsglist;
  /** Mutex for service registration **/

  /** Buffer to read messages **/
  uint8_t          m_rdbuffer[INC_CCA_MSG_MAX_LENGTH];

  /** Dispatcher entry **/
  static void*      vDpTaskEntry  (void* pvarg);
  /** Poll callback **/
  static void        vmainloopcb(int evFd, unsigned int events);
  /** Function to handle a FI Message **/
  void          vHandleFiMsg(amt_tclBaseMessage* pmsg);
  /**
  * Add a listener for INC Port, default listener will be setup for localhost based ports
  */
  bool  bSetupListener(int inc_port, std::string lhost, std::string rhost);

protected:
  /**********************************************************************
  * FAKING REQUIRED CCA INTERFACES
  ***********************************************************************/
  /**
  * Called on New CCA message
  */
  virtual void vOnNewMessage (amt_tclBaseMessage* poMessage) = 0;
  /**
  * Called On any registered service state change
  */
  virtual void vOnServiceState
    (
      uint16_t u16ServiceId,
      uint16_t u16ServerId,
      uint16_t u16RegisterId,
      uint8_t u8ServiceState,
      uint16_t u16SubId  ) = 0;
#if 0
  /**
  * Called On listener setup complete
  */
  virtual void vOnListenerSetup() = 0;
#endif

public:
  /**
  * Destructor
  */
  virtual ~inc_fi_base();
  /**
  * helper function to send messages
  */
  virtual bool bPostMessage (amt_tclBaseMessage* poMessage);
};

/**
* Function to be invoked to initialize dlt
*/
void inc_fi_init_dlt(DltContext& ptrcontext);

#endif //INC_FI_BASE_H_INCLUDE_IF

